program MKQUOT;

{Copyright 1996 Jan Sjberg <janne@sjoberg-trading.se>

This program may be freely distributed and modified, as long as you, in the
program, mention my name and email.}

uses
    crt;

var
   in_file,
   out_file     :text;
   line,
   param        :string;
   antal_klar,
   total        :integer;
   x1,
   y1,
   x2,
   y2           :integer;
   noshow       :boolean;

function getnoshow:boolean;

         begin
              if paramcount=1 then getnoshow:=true else getnoshow:=false;
         end;

procedure print_stats;

          begin
               window(1,1,80,25);
               gotoxy(3,25);
               write('Completed: ',antal_klar,', ',((100*(antal_klar)) div (total+1)),'% of ',total);
               window(3,4,78,24);
          end;

procedure intro_screen;

          begin
               clrscr;
               writeln;
               writeln('  MKQUOT v1.11    (c) 1996 Jan Sjberg');
               writeln;
               print_stats;
          end;

procedure behandla(var line:string);

          var
             out_line   :text;
             i          :integer;

          begin
               assign(out_line,'mkquot.tmp');
               rewrite(out_line);
               write(out_line,'  "');
               for i:=1 to length(line) do begin
                   if line[i]=chr(34)
                      then write(out_line,'''')
                      else write(out_line,line[i]);
               end;
               writeln(out_line,'\n",');
               close(out_line);
               reset(out_line);
               readln(out_line,line);
               close(out_line);
          end;

procedure print_line(org_line,line:string);

          begin
               window(3,6,78,11);
               gotoxy(x1,y1);
               writeln(org_line);
               x1:=wherex;
               y1:=wherey;
               window(3,15,78,23);
               gotoxy(x2,y2);
               writeln(line);
               x2:=wherex;
               y2:=wherey;
          end;

procedure quote;

          var
             org_line   :string;

          begin
               writeln(out_file,'text x');
               writeln(out_file,'  {');
               repeat
                     readln(in_file,line);
                     org_line:=line;
                     behandla(line);
                     if not noshow then print_line(org_line,line);
                     writeln(out_file,line);
               until org_line='';
               writeln(out_file,'  };');
               writeln(out_file);
               inc(antal_klar);
               print_stats;
          end;

procedure get_total_new;

          var
             temp       :string;

          begin
               reset(in_file);
               while not eof(in_file) do begin
                     readln(in_file,temp);
                     if temp='' then inc(total);
                     print_stats;
               end;
               close(in_file);
               reset(in_file);
               rewrite(out_file);
               writeln(out_file,'## File created by MKQUOT 1.11 by Jan Sjberg, janne@sjoberg-trading.se');
               writeln(out_file);
               writeln(out_file,'## RESCOM RQUOTES.R');
               writeln(out_file,'## REN RQUOTES.R RQUOTES.PMS');
               writeln(out_file,'## COPY RQUOTES.PMS c:\pmail\mail');
               writeln(out_file,'## Activate by putting ~! in your signature');
               writeln;
               writeln(out_file,'headers off');
               writeln(out_file,'symbols off');
               writeln;
          end;

procedure get_total_old;

          var
             temp       :string;

          begin
               reset(out_file);
               while not eof(out_file) do begin
                     readln(out_file,temp);
                     if temp='' then inc(total);
                     print_stats;
               end;
               close(out_file);
               append(out_file);
               antal_klar:=total;
               reset(in_file);
               while not eof(in_file) do begin
                     readln(in_file,temp);
                     if temp='' then inc(total);
                     print_stats;
               end;
               close(in_file);
               reset(in_file);
          end;

procedure get_files;

          var
             in_file_name       :string;

          begin
               assign(out_file,'rquotes.r');
               writeln;
               write('Name of input file? ');
               readln(in_file_name);
               assign(in_file,in_file_name);
               writeln;
               writeln;
               write('Create new RQUOTES.R file, or append to old? (n/A)');
               if upcase(readkey)='N'
                  then get_total_new
                  else get_total_old;
          end;

begin
     noshow:=getnoshow;
     total:=0;
     antal_klar:=0;
     intro_screen;
     get_files;
     clrscr;
     gotoxy(1,1);
     writeln('Input line:');
     gotoxy(1,10);
     writeln('Output line:');
     while not eof(in_file) do quote;
     close(in_file);
     close(out_file);
     window(1,1,80,25);
     clrscr;
end.



